package demo.forms;

import java.io.IOException;
import java.util.Vector;
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import demo.*;
import demo.data.*;

/**
 * Ecran affichant le rsultat d'une requte dans la base
 * de donnes
*/
public class QueryResultsList extends List implements CommandListener, IState {
  // Rfrence la machine d'tat
  private IStateMachine parent;
  // Commande 'retour'
  private Command back;
  // Commande 'dtails'
  private Command details;
  // Vecteur d'objets Info pour stocker les rsultats de la requte
  private Vector infoLinks;

  /**
   * Construit un objet QueryResultsList avec le nom spcifi et la 
   * rfrence  son IStateMachine parent
   */
  public QueryResultsList(String name, IStateMachine parent) {
    super(name, List.IMPLICIT);
    this.parent = parent;
    this.back = new Command("Retour", Command.BACK, 1);
    this.details = new Command("Dtails", Command.SCREEN, 1);
    addCommand(this.back);
    addCommand(this.details);
    setCommandListener(this);
  }

  /**
   * Vrifie quel nom d'information est actuellement slectionn  
   * l'cran et retourne l'objet InfoLink correspondant ou null 
   * si aucun n'est slectionn
   */
  private InfoLink getSelectedInfo() {
    int index = getSelectedIndex();
    String titre = getString(index);
    int n = this.infoLinks.size();
    for (int i = 0; i < n; i++) {
      InfoLink pl = (InfoLink) this.infoLinks.elementAt(i);
      if (pl.getTitre().equals(titre)) {
        return pl;
      }
    }
    return null;
  }

  /**
   * Ecran affichant le nom des informations rpondant aux critres 
   * de recherche
   */
  private void buildList(Object infoLinks) {
    if (size() != 0) clearScreen();
    this.infoLinks = (Vector) infoLinks;
    int n = this.infoLinks.size();
    if (n == 0) {
      append("Pas d'information trouve.", null);
      return;
    }
    for (int i = 0; i < n; i++) {
      InfoLink pl = (InfoLink) this.infoLinks.elementAt(i);
      append(pl.getTitre(), null);
    }
  }

  // Supprimer tous les lments de l'cran
  private void clearScreen() {
    int n = size();
    for (int i = 0; i < n; i++) delete(0);
  }

  /**
   * Appelle setCurrentState() sur la machine d'tat pour mettre  
   * jour l'tat en fonction de la commande slectionne
   */
  public void commandAction(Command c, Displayable d) {
    if (c == this.back) {
      this.parent.setCurrentState(kb.STATE_QUERY, null);
    } else if (c == this.details) {
      InfoLink pl = getSelectedInfo();
      if (pl == null) {
        this.parent.setCurrentState(kb.STATE_QUERY, null);
      } else {
        Info info = null;
        try {
          info = RemoteServices.getInstance().getDetails(pl.getOid());
          this.parent.setCurrentState(kb.STATE_DETAILS, info);
        } catch (IOException ex) {
          Alert remoteAlert = new Alert("Erreur rseau", "Exception Message: " + ex.getMessage(), null, AlertType.ERROR);
          remoteAlert.setTimeout(5000);
          Display.getDisplay((MIDlet) parent).setCurrent(remoteAlert);
        }
      }
    }
  }

  /**
   * Quand l'tat courant est modifi, afficher le nom des 
   * informations qui rpondent aux critres de slection ou 
   * afficher le rsultat de la requte prcdente si aucun 
   * eventData n'est spcifi
   */
  public void handleTransition(Object eventData) {
    Vector infoLinks = (Vector) eventData;
    if (infoLinks != null) {
      buildList(infoLinks);
    }
  }
}
